#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	<windows.h>

typedef struct {
	unsigned long	type;
	int				no;
	LONGLONG		offset;
	LONGLONG		size;
	char			name[1024];
} CLG;

unsigned char getbyte( unsigned char *ptr )
{
	return *ptr;
}



unsigned short getword( unsigned char *ptr )
{
	return (getbyte( ptr + 1 ) <<  8) + getbyte( ptr );
}



unsigned long getlong( unsigned char *ptr )
{
	return (getword( ptr + 2 ) << 16) + getword( ptr );
}



LONGLONG getlonglong( unsigned char *ptr )
{
	return ((LONGLONG)getlong( ptr + 4 ) << 32) + getlong( ptr );
}



const char *typedata[] = {
	"Unknown",
	"VB",
	"VH",
	"SEQ",
	"GPMhead",
	"GPMseq",
};

const char *gettype( unsigned long type ) {
	int	result = 0;
	switch( type ) {
	case 0x00004256: result = 1; break;	/* VB		*/
	case 0x00004856: result = 2; break;	/* VH		*/
	case 0x00514553: result = 3; break;	/* SEQ		*/
	case 0x53537371: result = 4; break;	/* GPMseq	*/
	case 0x53536864: result = 5; break;	/* GPMhead	*/
	}
	return typedata[result];
}



int main( int argc, char **argv )
{
	FILE	*fp;
	char	infile[_MAX_PATH], outfile[_MAX_PATH];
	int		fnamelen;
	char	*data, *dat0;
	int		i, size, num, len;
	CLG		*clg;

	if( argc <= 1 ) {
		printf( "cgl2csv ver 0.00\n" );
		return -1;
	}
	strcpy( infile, argv[1] );
	fnamelen = strlen( infile ) - 4;
	if( fnamelen > 0 ) {
		if( !strstr( &infile[fnamelen], ".clg" ) ) {
			strcat( infile, ".clg" );
		}
	} else {
		strcat( infile, ".clg" );
	}
	if( argc <= 2 ) {
		strcpy( outfile, infile );
		strcpy( &outfile[strlen( outfile ) - 4], ".csv" );
	} else {
		strcpy( outfile, argv[2] );
		fnamelen = strlen( outfile ) - 4;
		if( fnamelen > 4 ) {
			if( !strstr( &outfile[fnamelen], ".csv" ) ) {
				strcat( outfile, ".csv" );
			}
		} else {
			strcat( outfile, ".cvs" );
		}
	}
	printf( "convert %s->%s\n", infile, outfile );

	fp = fopen( infile, "rb" );
	if( !fp ) {
		printf( "t@C܂:%s\n", infile );
		return -1;
	}
	fseek( fp, 0, SEEK_END );
	size = ftell( fp );
	fseek( fp, 0, SEEK_SET );
	dat0 = malloc( size );
	if( !dat0 ) {
		printf( "ǂݍݗp̃mۏo܂ł\n" );
		return -1;
	}
	fread( dat0, size, 1, fp );
	fclose( fp );

	data = dat0;
	num = (int)getlong( data );
	size -= 4;
	data += 4;
	len = getbyte(data );
	size -= (len+1);
	data += (len+1);
	clg = malloc( sizeof(CLG) * num );
	if( !clg ) {
		printf( "Ɨp̃mۏo܂ł\n" );
		return -1;
	}
	for( i= 0; i < num; i++ ) {
		clg[i].type = getlong( data );
		data += 4;
		clg[i].no = getlong( data );
		data += 4;
		clg[i].offset = getlonglong( data );
		data += 8;
		len = getbyte( data );
		data++;
		strcpy( clg[i].name, data );
		data += len;
	}
	free( dat0 );

	for( i= 0; i < num-1; i++ ) {
		clg[i].size = clg[i+1].offset - clg[i].offset;
	}
	clg[i].size = 0;
	
	fp = fopen( outfile, "wt" );
	if( !fp ) {
		printf( "t@C쐬o܂:%s\n", outfile );
		return -1;
	}
	fprintf( fp, "TYPE,NO,OFFSET,SIZE,FINENAME\n" );
	for( i = 0; i < num; i++ ) {
		fprintf( fp, "%s,%d,%I64d,%I64d,%s\n",
			gettype( clg[i].type ), clg[i].no, clg[i].offset, clg[i].size, clg[i].name );
	}
	fclose( fp );
	free( clg );
	return 0;
}
