

;; Patch the game loop to display debug strings
;; 
.org 0x80026978
				j		0x80032908				;; jump to custom code
				nop
.org 0x80032908									;; This is a function area that was originally
.area 0x1E8										;; used for STR playback. Because CAPCOM.STR
												;; logo playback is patched to be skipped in
												;; LOGO.EXE, this function goes completely
												;; unused. Therefore, custom code and data can
												;; be written in this area without worry of
												;; crashing the system.

				;; By default, the engine utilizes the start button on controller 2
				;; to cycle through various debug stats. Using this same technique,
				;; a trigger is setup here to avoid a constant black screen while
				;; playing the game.
				lbu		$v0, 0x8008DC98			;; is the debug menu active?
				nop
				beqz	$v0, @TestController	;; if not, test if player pressed start button
				nop
				j		@FntLoad				;; if yes, print is definitely required
				nop
				@TestController:
				lhu		$v0, 0x800DBEE2			;; read controller 2 input
				nop
				andi	$v0, 0x800				;; did player press start button on controller 2?
				bnez	$v0, @FntLoad			;; player pressed start button, print required
				nop
				j		@Complete				;; player did not press start, print nothing
				nop

				@FntLoad:
				li		$a0, 960				;; VRAM X
				jal		0x80044E64				;; execute FntLoad() function
				li		$a1, 256				;; VRAM Y

				;; Initialize
				li      $a0, 0					;; box screen position X
				li      $a1, 0					;; box screen position Y
				li      $a2, 256				;; box width
				li      $a3, 192				;; box height
				li      $v0, 0					;; automatic clearing of background (0=YES,1=NO)
				sw      $v0, 0x20+-0x20($sp)	;; automatic clearing of background (0=YES,1=NO)
				li      $v0, 0x200				;; maximum number of characters in string (512)
				sw      $v0, 0x20+-0x1C($sp)	;; maximum number of characters in string (512)
				jal     0x80044F08				;; execute FntOpen() function
				sw      $ra, 0x20+-0x18($sp)	;; adjust stack register
				jal     0x80044E24				;; execute SetDumpFnt() function
				move    $a0, $v0				;; FntOpen() return value (stream ID to be used)

				;; Debug
				jal		0x80029844				;; event flag function
				nop
				jal		0x8003CC88				;; player position function
				nop
				jal		0x80024760				;; debug stats function
				nop

				;; FntFlush
				li      $a0, -1					;; stream ID (-1 for ID set by SetDumpFnt() function)
				jal		0x800451D4				;; execute FntFlush() function
				nop

				;; execute vanilla code that was replaced by injection and return
				;; to the engine's game loop for normal processing
				@Complete:
				lhu		$v0, 0x800DBEE2			;; test controller 2 input
				nop
				andi	$v0, 0x800				;; start button
				j		0x80026988				;; return to game loop
				nop
.endarea
